/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.applets;

import coldfusion.applets.CFGrid;
import coldfusion.applets.CFGridDescription;
import coldfusion.applets.CFGridTableModelAdapter;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.table.TableModel;

class CFGridActionListener
implements ActionListener {
    private final CFGridDescription m_gridDesc;
    private final CFGrid m_table;
    private final TableModel m_tm;
    private int m_iLastSelectedCol = -1;
    private final int ASCENDING = 1;
    private final int DESCENDING = 2;

    CFGridActionListener(CFGrid cFGrid, CFGridDescription cFGridDescription) {
        this.m_gridDesc = cFGridDescription;
        this.m_table = cFGrid;
        this.m_tm = this.m_table.getModel();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("insert")) {
            this.insertRow();
        } else if (string.equals("delete")) {
            this.deleteRow();
        } else if (string.equals("sortasc")) {
            this.sort(1);
        } else if (string.equals("sortdsc")) {
            this.sort(2);
        }
    }

    private void sort(int n) {
        int n2 = this.m_table.getSelectedColumn();
        if (n2 == -1) {
            n2 = this.m_iLastSelectedCol;
        } else {
            this.m_iLastSelectedCol = n2;
        }
        if (n2 != -1 && this.m_tm instanceof CFGridTableModelAdapter) {
            CFGridTableModelAdapter cFGridTableModelAdapter = (CFGridTableModelAdapter)this.m_tm;
            cFGridTableModelAdapter.sortByColumn(n2, n == 1);
        }
    }

    private void insertRow() {
        if (this.m_tm instanceof CFGridTableModelAdapter) {
            boolean bl;
            CFGridTableModelAdapter cFGridTableModelAdapter = (CFGridTableModelAdapter)this.m_tm;
            cFGridTableModelAdapter.insertRow();
            int n = this.m_table.getRowCount() - 1;
            if (this.m_gridDesc.getRowHeight() > 0) {
                this.m_table.setRowHeight(n, this.m_gridDesc.getRowHeight());
            }
            Rectangle rectangle = this.m_table.getCellRect(n, 0, false);
            this.m_table.scrollRectToVisible(rectangle);
            int n2 = this.m_table.getColumnCount() - 1;
            for (int i = 0; i < n2 && !(bl = this.m_table.editCellAt(n, i)); ++i) {
            }
        }
    }

    private void deleteRow() {
        int n = this.m_table.getSelectedRow();
        if (n != -1 && this.m_tm instanceof CFGridTableModelAdapter) {
            CFGridTableModelAdapter cFGridTableModelAdapter = (CFGridTableModelAdapter)this.m_tm;
            cFGridTableModelAdapter.deleteRow(n);
        }
    }
}

