/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.applets;

import coldfusion.applets.CFCtrlUtils;
import coldfusion.applets.CFTreeUserObject;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;

class CFTreeCellRenderer
extends DefaultTreeCellRenderer {
    private boolean m_bDefaultsSaved = false;
    private Color m_colorTextDefault = null;
    private Icon m_iconClosedDefault = null;
    private Icon m_iconOpenDefault = null;
    private Icon m_iconLeafDefault = null;
    private boolean m_bUnderline = false;

    CFTreeCellRenderer() {
    }

    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
        Object object2 = defaultMutableTreeNode.getUserObject();
        if (object2 instanceof CFTreeUserObject) {
            CFTreeUserObject cFTreeUserObject = (CFTreeUserObject)object2;
            if (!this.m_bDefaultsSaved) {
                this.saveDefaults();
            }
            if (cFTreeUserObject.getHighlightRef() && cFTreeUserObject.getUrlHref() != null) {
                this.m_bUnderline = true;
                this.setTextNonSelectionColor(Color.blue);
                if (cFTreeUserObject.getLinkHasBeenTraversed()) {
                    this.setTextNonSelectionColor(Color.cyan);
                }
            } else {
                this.m_bUnderline = false;
                this.setTextNonSelectionColor(this.m_colorTextDefault);
            }
            if (cFTreeUserObject.getImageStdIcon() != null) {
                if (bl3) {
                    this.setLeafIcon(cFTreeUserObject.getImageStdIcon());
                } else {
                    this.setClosedIcon(cFTreeUserObject.getImageStdIcon());
                }
            } else if (bl3) {
                this.setLeafIcon(this.m_iconLeafDefault);
            } else {
                this.setClosedIcon(this.m_iconClosedDefault);
            }
            if (cFTreeUserObject.getImageOpenIcon() != null) {
                this.setOpenIcon(cFTreeUserObject.getImageOpenIcon());
            } else if (cFTreeUserObject.getImageStdIcon() != null) {
                this.setOpenIcon(cFTreeUserObject.getImageStdIcon());
            } else {
                this.setOpenIcon(this.m_iconOpenDefault);
            }
        }
        super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
        return this;
    }

    private void saveDefaults() {
        this.m_colorTextDefault = this.getTextNonSelectionColor();
        this.m_iconClosedDefault = this.getClosedIcon();
        this.m_iconOpenDefault = this.getOpenIcon();
        this.m_iconLeafDefault = this.getLeafIcon();
        this.m_bDefaultsSaved = true;
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.m_bUnderline && this instanceof JLabel) {
            CFTreeCellRenderer cFTreeCellRenderer = this;
            CFCtrlUtils.underlineTextInLabel(cFTreeCellRenderer, graphics);
        }
    }
}

